/**
 *    author:  wxhtzdy
 *    created: 19.11.2022 13:33:30
**/
#include <bits/stdc++.h>

using namespace std;

/* 
static struct FastInput {
  static constexpr int BUF_SIZE = 1 << 20;
  char buf[BUF_SIZE];
  size_t chars_read = 0;
  size_t buf_pos = 0;
  FILE *in = stdin;
  char cur = 0;
 
  inline char get_char() {
    if (buf_pos >= chars_read) {
      chars_read = fread(buf, 1, BUF_SIZE, in);
      buf_pos = 0;
      buf[0] = (chars_read == 0 ? -1 : buf[0]);
    }
    return cur = buf[buf_pos++];
  }
 
  inline void tie(int) {}
 
  inline explicit operator bool() {
    return cur != -1;
  }
 
  inline static bool is_blank(char c) {
    return c <= ' ';
  }
 
  inline bool skip_blanks() {
    while (is_blank(cur) && cur != -1) {
      get_char();
    }
    return cur != -1;
  }
 
  inline FastInput& operator>>(char& c) {
    skip_blanks();
    c = cur;
    get_char();
    return *this;
  }
  
  inline FastInput& operator>>(string& s) {
    if (skip_blanks()) {
      s.clear();
      do {
        s += cur;
      } while (!is_blank(get_char()));
    }
    return *this;
  }
 
  template <typename T>
  inline FastInput& read_integer(T& n) {
    // unsafe, doesn't check that characters are actually digits
    n = 0;
    if (skip_blanks()) {
      int sign = +1;
      if (cur == '-') {
        sign = -1;
        get_char();
      }
      do {
        n += n + (n << 3) + cur - '0';
      } while (!is_blank(get_char()));
      n *= sign;
    }
    return *this;
  }
 
  template <typename T>
  inline typename enable_if<is_integral<T>::value, FastInput&>::type operator>>(T& n) {
    return read_integer(n);
  }
  
  #if !defined(_WIN32) || defined(_WIN64)
  inline FastInput& operator>>(__int128& n) {
    return read_integer(n);
  }
  #endif
 
  template <typename T>
  inline typename enable_if<is_floating_point<T>::value, FastInput&>::type operator>>(T& n) {
    // not sure if really fast, for compatibility only
    n = 0;
    if (skip_blanks()) {
      string s;
      (*this) >> s;
      sscanf(s.c_str(), "%lf", &n);
    }
    return *this;
  }
} fast_input;
 
#define cin fast_input
 
static struct FastOutput {
  static constexpr int BUF_SIZE = 1 << 20;
  char buf[BUF_SIZE];
  size_t buf_pos = 0;
  static constexpr int TMP_SIZE = 1 << 20;
  char tmp[TMP_SIZE];
  FILE *out = stdout;
 
  inline void put_char(char c) {
    buf[buf_pos++] = c;
    if (buf_pos == BUF_SIZE) {
      fwrite(buf, 1, buf_pos, out);
      buf_pos = 0;
    }
  }
 
  ~FastOutput() {
    fwrite(buf, 1, buf_pos, out);
  }
 
  inline FastOutput& operator<<(char c) {
    put_char(c);
    return *this;
  }
 
  inline FastOutput& operator<<(const char* s) {
    while (*s) {
      put_char(*s++);
    }
    return *this;
  }
 
  inline FastOutput& operator<<(const string& s) {
    for (int i = 0; i < (int) s.size(); i++) {
      put_char(s[i]);
    }
    return *this;
  }
 
  template <typename T>
  inline char* integer_to_string(T n) {
    // beware of TMP_SIZE
    char* p = tmp + TMP_SIZE - 1;
    if (n == 0) {
      *--p = '0';
    } else {
      bool is_negative = false;
      if (n < 0) {
        is_negative = true;
        n = -n;
      }
      while (n > 0) {
        *--p = (char) ('0' + n % 10);
        n /= 10;
      }
      if (is_negative) {
        *--p = '-';
      }
    }
    return p;
  }
 
  template <typename T>
  inline typename enable_if<is_integral<T>::value, char*>::type stringify(T n) {
    return integer_to_string(n);
  }
 
  #if !defined(_WIN32) || defined(_WIN64)
  inline char* stringify(__int128 n) {
    return integer_to_string(n);
  }
  #endif
 
  template <typename T>
  inline typename enable_if<is_floating_point<T>::value, char*>::type stringify(T n) {
    sprintf(tmp, "%.17f", n);
    return tmp;
  }
 
  template <typename T>
  inline FastOutput& operator<<(const T& n) {
    auto p = stringify(n);
    for (; *p != 0; p++) {
      put_char(*p);
    }
    return *this;
  }
} fast_output;
 
#define cout fast_output
*/ 
/*
string to_string(string s) {
  return '"' + s + '"';
}
string to_string(const char* s) {
  return to_string((string) s);
}
string to_string(bool b) {
  return (b ? "true" : "false");
}
template <typename A, typename B>
string to_string(pair<A, B> p) {
  return "(" + to_string(p.first) + ", " + to_string(p.second) + ")";
}
template <typename A>
string to_string(A v) {
  bool first = true;
  string res = "{";
  for (const auto &x : v) {
    if (!first) {
      res += ", ";
    }
    first = false;
    res += to_string(x);
  }
  res += "}";
  return res;
}
void debug_out() { cerr << endl; }
template <typename Head, typename... Tail>
void debug_out(Head H, Tail... T) {
  cerr << " " << to_string(H);
  debug_out(T...);
}
#ifdef LOCAL
#define debug(...) cerr << "[" << #__VA_ARGS__ << "]:", debug_out(__VA_ARGS__)
#else
#define debug(...) 42
#endif
*/

const int N = 200005;
const int L = 18;

int a[N];
vector<vector<int>> g(N);

int pv[N], pr[L][N], dfn[N], dfo[N], dep[N];
long long fenw[N];
    
void Modify(int x, int v) {
  for (x++; x < N; x += x & -x) {
    fenw[x] += v;
  }
}

long long Get(int x) {
  long long res = 0;
  for (x++; x > 0; x -= x & -x) {
    res += fenw[x];
  }
  return res;
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(0);  
  int n;
  cin >> n;
  // vector<vector<int>> g(n);
  for (int i = 1; i < n; i++) {
    int u, v;
    cin >> u >> v;
    --u; --v;
    g[u].push_back(v);
    g[v].push_back(u);
  }
  for (int i = 0; i < n; i++) {
    cin >> a[i];
  }
  /* const int L = 18;
  vector<int> pv(n);
  vector<vector<int>> pr(L, vector<int>(n));
  vector<int> dfn(n);
  vector<int> dfo(n);
  vector<int> dep(n); */
  int T = -1;       
  function<void(int, int)> Dfs = [&](int v, int par) {
    pv[v] = par;
    dfn[v] = ++T;  
    for (int u : g[v]) {
      if (u == par) {
        continue;
      }    
      dep[u] = dep[v] + 1;
      Dfs(u, v);
    } 
    dfo[v] = T;
  };
  Dfs(0, 0);
  auto IsAnc = [&](int x, int y) {
    return dfn[x] <= dfn[y] && dfo[y] <= dfo[x];   
  };               
  auto LCA = [&](int x, int y) {
    if (IsAnc(x, y)) {
      return x;
    }
    for (int i = L - 1; i >= 0; i--) {
      if (!IsAnc(pr[i][x], y)) {
        x = pr[i][x];
      }
    }
    return pv[x];
  };         
  for (int i = 0; i < n; i++) {
    pr[0][i] = pv[i];
  }
  for (int j = 1; j < L; j++) {
    for (int i = 0; i < n; i++) {
      pr[j][i] = pr[j - 1][pr[j - 1][i]];
    }
  }        
  //fenwick<long long> fenw(n);
  for (int i = 0; i < n; i++) {
    Modify(dfn[i], +a[i]);
  }
  long long total = 0LL;
  for (int i = 0; i < n; i++) {
    total += a[i];
  }
  auto GetSum = [&](int x) {
    return Get(dfo[x]) - Get(dfn[x] - 1);
  };
  auto GoUp = [&](int x, int k) {
    for (int i = L - 1; i >= 0; i--) {
      if (k >> i & 1) {
        x = pr[i][x];
      }
    }
    return x;
  };
  int idx = 0;
  for (int i = 1; i < n; i++) {
    //debug(i, GetSum(i));
    if (GetSum(i) < GetSum(idx) && GetSum(i) * 2 >= total) {
      idx = i;
    }
  }
  if (GetSum(idx) * 2 == total) {
    idx = min(idx, pv[idx]);
  }
  cout << idx + 1 << '\n';
  int q;
  cin >> q;
  while (q--) {
    int z, b;
    cin >> z >> b;
    --b;
    total += z;
    Modify(dfn[b], +z);
    if (IsAnc(idx, b)) {
      //cout << "Case 1" << " ";
      idx = b;
      for (int i = L - 1; i >= 0; i--) {
        if (GetSum(pr[i][idx]) * 2 < total) {
          idx = pr[i][idx];          
        }         
      }
      if (GetSum(idx) * 2 < total) {
        idx = pv[idx];
      }                 
    } else if (IsAnc(b, idx)) {
      //cout << "Case 2" << " ";
      for (int i = L - 1; i >= 0; i--) {
        if (GetSum(pr[i][idx]) * 2 < total) {
          idx = pr[i][idx];          
        }         
      }
      if (GetSum(idx) * 2 < total) {
        idx = pv[idx];
      }
    } else {
      //cout << "Case 3" << " ";
      int x = LCA(idx, b);
      int y = GoUp(idx, dep[idx] - dep[x] - 1);
      if (GetSum(y) * 2 < total) {
        idx = b;
      }
      for (int i = L - 1; i >= 0; i--) {
        if (GetSum(pr[i][idx]) * 2 < total) {
          idx = pr[i][idx];
        }
      }    
      if (GetSum(idx) * 2 < total) {
        idx = pv[idx];
      }
    }
    if (GetSum(idx) * 2 == total) {
      idx = min(idx, pv[idx]);
    }
    cout << idx + 1 << '\n';
  }
  //debug(clock());       
  return 0;
}